<?php

namespace Ptb\Pace\Requests;

use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasFormBody;
use Saloon\Traits\Body\HasJsonBody;

class CreateObject extends Request implements HasBody
{
    use HasJsonBody;

    /**
     * The HTTP method of the request
     */
    protected Method $method = Method::POST;

    /**
     * The endpoint for the request
     */
    public function resolveEndpoint(): string
    {
        return "/CreateObject/create{$this->type}";
    }

    /**
     * @return array[]
     */
    protected function defaultBody(): array
    {
        return $this->data;
    }

    public function __construct(
        private readonly string $type,
        private readonly array $data,
    ) {
        //
    }
}
