<?php

namespace Ptb\Pace\Requests;

use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

class CloneObject extends Request implements HasBody
{
    use HasJsonBody;

    /**
     * The HTTP method of the request
     */
    protected Method $method = Method::POST;

    /**
     * The endpoint for the request
     */
    public function resolveEndpoint(): string
    {
        return "/CloneObject/clone{$this->type}";
    }

    protected function defaultQuery(): array
    {
        return [
            'keyOfObjectToClone' => $this->keyOfObjectToClone,
            'newParentKey' => $this->newParentKey,
            'newPrimaryKey' => $this->newPrimaryKey,
        ];
    }

    protected function defaultBody(): array
    {
        return [
            $this->type => $this->data,
        ];
    }

    public function __construct(
        private readonly string $type,
        private readonly string $keyOfObjectToClone,
        private readonly string $newParentKey,
        private readonly array $data,
        private readonly ?string $newPrimaryKey = null,

    ) {
        //
    }
}
