<?php

namespace Ptb\Pace\Query;

use JsonException;
use Ptb\Pace\PaceRestConnector;
use Ptb\Pace\Requests\ReadObject;
use Saloon\Exceptions\Request\FatalRequestException;
use Saloon\Exceptions\Request\RequestException;
use Saloon\Http\Response;
use Throwable;

trait Queryable
{

    /**
     * @return Builder
     */
    public static function query(): Builder
    {
        $reflection = new \ReflectionClass(static::class);

        return new Builder(
            objectName: $reflection->getShortName(),
            dataClass: static::class
        );
    }

    /**
     * @param mixed $primaryKey
     * @return mixed
     * @throws FatalRequestException
     * @throws RequestException
     * @throws Throwable
     */
    public static function find(mixed $primaryKey): static
    {
        return match (gettype($primaryKey)) {
            'string' => self::fromString($primaryKey),
            'integer' => self::fromString( (string) $primaryKey),
        };
    }

    /**
     * @param string $primaryKey
     * @return static
     * @throws FatalRequestException
     * @throws RequestException
     * @throws Throwable
     */
    public static function fromString(string $primaryKey): static
    {
        $reflection = new \ReflectionClass(static::class);

        $response = app(PaceRestConnector::class)
            ->send(
                request: new ReadObject(type: $reflection->getSHortName(), primaryKey: $primaryKey)
            );

        if ($response->failed()) {
            $response->throw();
        }

        return self::fromResponse($response);
    }

    /**
     * @param Response $response
     * @return static
     * @throws JsonException
     */
    public static function fromResponse(Response $response): static
    {
        return static::from($response->json());
    }
}