<?php

namespace Ptb\Pace\Models;

use Carbon\Carbon;
use Ptb\Pace\Castables\ToCarbon;
use Ptb\Pace\Query\Queryable;
use Ptb\Pace\Transformers\AsCarbon;
use Spatie\LaravelData\Attributes\WithCastable;
use Spatie\LaravelData\Attributes\WithTransformer;
use Spatie\LaravelData\Data;


class ShipVia extends Data
{
    use Queryable;

    public function __construct(
        public bool|null   $active,
        public mixed       $activityCode,
        public string|null $altDescription,
        public bool|null   $availForRelay,
        public bool|null   $availableInEcommerce,
        public bool|null   $billOfLading,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $cutOffTime,
        public int|null    $dateCalcType,
        public int|null    $daysintransit,
        public string|null $description,
        public bool|null   $dsfDeliveryMethod,
        public mixed       $dsfEntry,
        public bool|null   $dsfShared,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $earliestDeliveryTime,
        public string|null $externalCodeForHandlingCharge,
        public string|null $externalCodeForTax,
        public int|null    $hoursInTransit,
        public mixed       $id,
        public string|null $ioID,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lastModified,
        public string|null $legacyTrackingUrl,
        public float|null  $maxWeightPerBox,
        public float|null  $maximumWeight,
        public float|null  $minimumWeight,
        public bool|null   $multiBoxShipping,
        public mixed       $provider,
        public mixed       $sourceOrganizationCompany,
        public array|null  $tags,
        public int|null    $templateLine,
        public string|null $upsMethod,
    )
    {
        //
    }

}
