<?php

namespace Ptb\Pace\Models;

use Carbon\Carbon;
use Ptb\Pace\Castables\ToCarbon;
use Ptb\Pace\Query\Queryable;
use Ptb\Pace\Transformers\AsCarbon;
use Spatie\LaravelData\Attributes\WithCastable;
use Spatie\LaravelData\Attributes\WithTransformer;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\DataCollection;


class SalesCategory extends Data
{
    use Queryable;

    public function __construct(
        public bool|null   $active,
        public float|null  $autoAmtInBill,
        public float|null  $autoPercentInBill,
        public bool|null   $commission,
        public bool|null   $commissionable,
        public mixed       $glAccount,
        public mixed       $glDepartment,
        public mixed       $glLocation,
        public mixed       $id,
        public bool|null   $includeInDiscount,
        public bool|null   $salesReport,
        public string|null $ioID,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lastModified,
        public string|null $name,
        public string|null $oldGLAccount,
        public string|null $oldGLLocation,
        public mixed       $sourceOrganizationCompany,
        public array|null  $tags,
        public bool|null   $taxReport,
        public bool|null   $taxable,
        public int|null    $templateLine,
    )
    {
        //
    }

    /**
     * Query only active objects
     *
     * @return DataCollection
     */
    public static function active(): DataCollection
    {
        $builder = static::getXPathBuilder();
        $builder->filter('@active', true);

        return static::filter($builder);
    }
}
