<?php

namespace Ptb\Pace\Models;

use Carbon\Carbon;
use Ptb\Pace\Castables\ToCarbon;
use Ptb\Pace\Query\Queryable;
use Ptb\Pace\Transformers\AsCarbon;
use Spatie\LaravelData\Attributes\WithCastable;
use Spatie\LaravelData\Attributes\WithTransformer;
use Spatie\LaravelData\Data;


class NonChargeableType extends Data
{
    use Queryable;

    public function __construct(
        public bool|null   $active,
        public string|null $askCostCenter,
        public string|null $askNote,
        public mixed       $costCenter,
        public string|null $description,
        public mixed       $id,
        public string|null $ioID,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lastModified,
        public bool|null   $paid,
        public int|null    $plantManagerDMICategory,
        public int|null    $plantManagerId,
        public int|null    $plantManagerReportCategory,
        public mixed       $sourceOrganizationCompany,
        public array|null  $tags,
        public int|null    $templateLine,
    )
    {
        //
    }

}
