<?php

namespace Ptb\Pace\Models;

use Carbon\Carbon;
use Ptb\Pace\Castables\ToCarbon;
use Ptb\Pace\Query\Queryable;
use Ptb\Pace\Transformers\AsCarbon;
use Spatie\LaravelData\Attributes\WithCastable;
use Spatie\LaravelData\Attributes\WithTransformer;
use Spatie\LaravelData\Data;


class JobCost extends Data
{
    use Queryable;

    public function __construct(
        public mixed       $activityCode,
        public float|null  $actualCost,
        public float|null  $actualHours,
        public int|null    $actualInventoryQty,
        public int|null    $actualProdUnits,
        public bool|null   $approved,
        public bool|null   $autoPost,
        public int|null    $beginCount,
        public float|null  $beginMeter,
        public mixed       $billRate,
        public string|null $billPremium,
        public int|null    $chargeClass,
        public bool|null   $closeActivity,
        public bool|null   $closed,
        public string|null $complete,
        public mixed       $component,
        public int|null    $correlationId,
        public float|null  $cost,
        public int|null    $countDifference,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $dateExpensed,
        public bool|null   $editFlag,
        public mixed       $employee,
        public mixed       $employeeTime,
        public int|null    $endCount,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $endDate,
        public float|null  $endMeter,
        public string|null $estimate,
        public string|null $estimatePart,
        public string|null $estimateSource,
        public float|null  $estimatedCost,
        public float|null  $estimatedHours,
        public int|null    $estimatedInventoryQty,
        public float|null  $estimatedSell,
        public bool|null   $failedAutoPost,
        public string|null $failedAutoPostReason,
        public float|null  $gangedEstimatedHours,
        public float|null  $hours,
        public mixed       $id,
        public bool|null   $inWIP,
        public float|null  $inventoryCost,
        public mixed       $inventoryItem,
        public mixed       $inventoryLine,
        public int|null    $inventoryQty,
        public mixed       $invoice,
        public mixed       $invoiceExtra,
        public string|null $jdfSource,
        public mixed       $job,
        public string|null $jobPart,
        public mixed       $JobPartKey,
        public mixed       $jobPlan,
        public string|null $journalCode,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lastModified,
        public bool|null   $negated,
        public mixed       $nonPlannedReason,
        public string|null $notes,
        public bool|null   $overlap,
        public bool|null   $overrideJobStatus,
        public bool|null   $pause,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $pausedDate,
        public float|null  $pausedHours,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $pausedTime,
        public float|null  $payrollCost,
        public int|null    $plantManagerId,
        public bool|null   $postable,
        public float|null  $postageUsed,
        public bool|null   $posted,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $postedDate,
        public string|null $postingStatus,
        public int|null    $printFlowSplitNumber,
        public int|null    $prodUnits,
        public mixed       $purchaseOrder,
        public mixed       $purchaseOrderLine,
        public mixed       $purchaseOrderReceipt,
        public bool|null   $quickEntry,
        public string|null $quoteSource,
        public mixed       $rate,
        public int|null    $registerNum,
        public int|null    $shift,
        public string|null $sourceID,
        public mixed       $sourceOrganizationCompany,
        public string|null $sourceType,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $startDate,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $startTime,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $stopTime,
        public array|null  $tags,
        public int|null    $templateLine,
        public float|null  $totalEstimatedHours,
        public int|null    $transactionType,
        public mixed       $vendor,
    )
    {
        //
    }

}
