<?php

namespace Ptb\Pace\Models;

use Carbon\Carbon;
use Ptb\Pace\Castables\ToCarbon;
use Ptb\Pace\Query\Queryable;
use Ptb\Pace\Transformers\AsCarbon;
use Spatie\LaravelData\Attributes\WithCastable;
use Spatie\LaravelData\Attributes\WithTransformer;
use Spatie\LaravelData\Data;


class Job extends Data
{
    use Queryable;

    public function __construct(
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $earliestProofDueDate,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $earliestProofShipDate,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $earliestProofShipTime,
        public string|null $state,
        public mixed       $customer,
        public string|null $description,
        public string|null $description2,
        public string|null $enteredBy,
        public mixed       $job,
        public mixed       $jobType,
        public mixed       $subJobType,
        public int|null    $totalParts,
        public mixed       $salesPerson,
        public mixed       $csr,
        public mixed       $shipVia,
        public int|null    $routingTemplate,
        public string|null $adminStatus,
        public string|null $prevAdminStatus,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $dateSetup,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $timeSetup,
        public string|null $poNum,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $promiseDate,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $promiseTime,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $scheduledShipDate,
        public bool|null   $scheduledShipDateForced,
        #[WithCastable(ToCarbon::class)]
        public Carbon|null $scheduledShipTime,
        #[WithTransformer(AsCarbon::class)]
        public bool|null   $scheduledShipTimeForced,
        public string|null $contactFirstName,
        public string|null $contactLastName,
        public int|null    $priority,
        public mixed       $jobProductType,
        public int|null    $jobProject,
        public string|null $quoteNumber,
        public string|null $attachment,
        public string|null $reference,
        public int|null    $jobOrderType,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $earliestStartDate,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $earliestStartTime,
        public bool|null   $readyToSchedule,
        public int|null    $jobJacketVersion,
        public string|null $pnref,
        public string|null $freeFormAccountNumber,
        public int|null    $qtyShipped,
        public string|null $crmId,
        public float|null  $jobValue,
        public string|null $statusComment,
        public string|null $prevStatusComment,
        public int|null    $statusReason,
        public int|null    $prevStatusReason,
        public string|null $statusReasonComment,
        public string|null $prevStatusReasonComment,
        public int|null    $scheduledFlag,
        public int|null    $prePressScheduledFlag,
        public int|null    $finishingScheduledFlag,
        public int|null    $salutation,
        public int|null    $certificationAuthority,
        public int|null    $certificationLevel,
        public int|null    $manufacturingLocation,
        public int|null    $totalOrderLines,
        public int|null    $opportunity,
        public float|null  $amountToInvoice,
        public bool|null   $amountToInvoiceForced,
        public int|null    $quantityOrdered,
        public bool|null   $quantityOrderedForced,
        public float|null  $originalQuotedPrice,
        public bool|null   $originalQuotedPriceForced,
        public mixed       $salesCategory,
        public bool|null   $salesCategoryForced,
        public float|null  $amountInvoiced,
        public float|null  $changeOrderTotal,
        public float|null  $freightAmountTotal,
        public mixed       $parentJob,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lastStatusChangedDate,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lastStatusChangedTime,
        public float|null  $billedAmt,
        public int|null    $qtyBilled,
        public float|null  $pendingBilledAmt,
        public string|null $sourceOrganizationCompany,
        public string|null $currentStatus,
        public string|null $earliestProofDue,
        public string|null $earliestProofShipDateTime,
        public string|null $noteToAdd,
        public float|null  $totalPriceAllParts,
        public float|null  $quantityRemaining,
        public float|null  $qtyOrdered,
        public bool|null   $scheduled,
        public bool|null   $prePressScheduled,
        public bool|null   $finishingScheduled,
        public string|null $primaryKey,
    )
    {
        //
    }

}
