<?php

namespace Ptb\Pace\Models;

use Carbon\Carbon;
use Ptb\Pace\Castables\ToCarbon;
use Ptb\Pace\Query\Queryable;
use Ptb\Pace\Transformers\AsCarbon;
use Spatie\LaravelData\Attributes\WithCastable;
use Spatie\LaravelData\Attributes\WithTransformer;
use Spatie\LaravelData\Data;


class InvoiceLine extends Data
{
    use Queryable;

    public function __construct(
        public float|null  $adjustedTotal,
        public string|null $billingCode,
        public float|null  $cost,
        public string|null $description,
        public bool|null   $flatPRice,
        public mixed       $id,
        public string|null $ioID,
        public mixed       $inventoryItem,
        public mixed       $invoice,
        public mixed       $jobMaterial,
        public string|null $jobPartReference,
        public string|null $jobProductReference,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lastModified,
        public int|null    $lineNum,
        public int|null    $lineType,
        public bool|null   $memoCreated,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $memoCreatedDate,
        public bool|null   $posted,
        public int|null    $priceChanged,
        public bool|null   $printStreamLotLine,
        public int|null    $qtyInvoiced,
        public int|null    $qtyOrdered,
        public int|null    $qtyShipped,
        public mixed       $quoteItemType,
        public mixed       $salesCategory,
        public string|null $sourceData,
        public mixed       $sourceOrganizationCompany,
        public array|null  $tags,
        public int|null    $templateLine,
        public float|null  $totalPrice,
        public float|null  $totalPriceAdjustment,
        public float|null  $unitPrice,
        public mixed       $uom,
    )
    {
        //
    }
}
