<?php

namespace Ptb\Pace\Models;

use Carbon\Carbon;
use Ptb\Pace\Castables\ToCarbon;
use Ptb\Pace\Query\Queryable;
use Ptb\Pace\Transformers\AsCarbon;
use Spatie\LaravelData\Attributes\WithCastable;
use Spatie\LaravelData\Attributes\WithTransformer;
use Spatie\LaravelData\Data;


class FileAttachment extends Data
{
    use Queryable;

    public function __construct(
        public mixed       $attachment,
        public mixed       $attachmentCategory,
        public string|null $baseObject,
        public string|null $baseObjectKey,
        public string|null $createdBy,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $createdDate,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $createdTime,
        public string|null $description,
        public string|null $ext,
        public string|null $field,
        public bool|null   $generatedForEmail,
        public string|null $ioID,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lastModified,
        public mixed       $localFileAttachment,
        public bool|null   $manual,
        public string|null $mimeType,
        public string|null $name,
        public string|null $displaySize,
        public int|null    $size,
        public mixed       $sourceOrganizationCompany,
        public array|null  $tags,
        public int|null    $templateLine,
    )
    {
        //
    }

}
