<?php

namespace Ptb\Pace\Models;

use Carbon\Carbon;
use Ptb\Pace\Castables\ToCarbon;
use Ptb\Pace\Query\Queryable;
use Ptb\Pace\Transformers\AsCarbon;
use Spatie\LaravelData\Attributes\WithCastable;
use Spatie\LaravelData\Attributes\WithTransformer;
use Spatie\LaravelData\Data;


class EstimateQuantity extends Data
{
    use Queryable;

    public function __construct(
        public float|null  $additionalWeightPerPiece,
        public int|null    $allowableOvers,
        public bool|null   $alternatePrintMethodApplied,
        public string|null $chartDescription,
        public float|null  $comboPercent,
        public bool|null   $comboPercentForced,
        public float|null  $commRate,
        public float|null  $contributionAnalysisDiscount,
        public float|null  $contributionAnalysisTaxAmount,
        public float|null  $cost,
        public float|null  $costPerM,
        public string|null $description,
        public bool|null   $dirty,
        public int|null    $dirtyReason,
        public float|null  $effectiveCommissionRate,
        public bool|null   $effectiveCommissionRateForced,
        public mixed       $estimate,
        public mixed       $estimatePart,
        public float|null  $grandTotal,
        public int|null    $gripperColorBar,
        public mixed       $id,
        public string|null $ioID,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lastModified,
        public int|null    $manualWaste,
        public float|null  $marginPercent,
        public float|null  $markup,
        public float|null  $markupPercent,
        public float|null  $maxPaymentTermDiscount,
        public float|null  $maxPaymentTermDiscountPercent,
        public string|null $metrixID,
        public string|null $mxml,
        public string|null $mxmlFromMetrix,
        public string|null $mxmlToClient,
        public bool|null   $newQuantity,
        public float|null  $nextSequence,
        public float|null  $nonValueAddedMarkup,
        public bool|null   $nonValueAddedMarkupForced,
        public float|null  $nonValueAddedPercent,
        public float|null  $nonValueAddedPrice,
        public int|null    $numSigsOddPressForm,
        public int|null    $numSigsPerPressForm,
        public float|null  $outsidePurchaseMarkup,
        public bool|null   $outsidePurchaseMarkupForced,
        public float|null  $outsidePurchaseSetupMarkup,
        public bool|null   $outsidePurchaseSetupMarkupForced,
        public float|null  $overallInkCoverageSide1,
        public float|null  $overallInkCoverageSide2,
        public float|null  $overallMarkup,
        public bool|null   $overallMarkupForced,
        public float|null  $overallSellMarkup,
        public bool|null   $overallSellMarkupForced,
        public float|null  $paperMarkup,
        public bool|null   $paperMarkupForced,
        public int|null    $position,
        public string|null $positionState,
        public float|null  $price,
        public bool|null   $priceDirty,
        public float|null  $pricePerAddl100,
        public bool|null   $pricePerAddl100Forced,
        public float|null  $pricePerAddlM,
        public mixed       $pricePerAddlUOM,
        public bool|null   $pricePerAddlMForced,
        public mixed       $pricePerEach,
        public bool|null   $pricePerEachForced,
        public mixed       $pricePerUOM,
        public bool|null   $pricePerUOMForced,
        public mixed       $pricingUOM,
        public float|null  $pricingUnits,
        public bool|null   $pricingUnitsForced,
        public int|null    $quantityOrdered,
        public bool|null   $quotePriceForced,
        public bool|null   $quotePricePerAddlMForced,
        public float|null  $quotedPricePerAddl100,
        public bool|null   $quotedPricePerAddl100Forced,
        public float|null  $quotedPricePerAddlM,
        public float|null  $quotedPrice,
        public int|null    $sequence,
        public int|null    $sheetOffPress,
        public mixed       $sourceOrganizationCompany,
        public array|null  $tags,
        public float|null  $targetSell,
        public float|null  $taxAmount,
        public float|null  $taxBase,
        public float|null  $taxEffectivePercent,
        public int|null    $templateLine,
        public float|null  $valueAdded,
        public float|null  $valueAddedMarkup,
        public bool|null   $valueAddedMarkupForced,
        public float|null  $valueAddedPerPressHour,
        public float|null  $valueAddedPercent,
        public float|null  $valueAddedPrice,
        public float|null  $weightPerPiece,
    )
    {
        //
    }

}
