<?php

namespace Ptb\Pace\Models;

use Carbon\Carbon;
use Ptb\Pace\Castables\ToCarbon;
use Ptb\Pace\Query\Queryable;
use Ptb\Pace\Transformers\AsCarbon;
use Spatie\LaravelData\Attributes\WithCastable;
use Spatie\LaravelData\Attributes\WithTransformer;
use Spatie\LaravelData\Data;


class EstimatePartContentFile extends Data
{
    use Queryable;

    public function __construct(
        public int|null    $contentFile,
        public int|null    $contentFileCategory,
        public mixed       $estimatePart,
        public int|null    $id,
        public string|null $ioID,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lastModified,
        public mixed       $metricCutterOperations,
        public string|null $origin,
        public int|null    $sequence,
        public int|null    $sourceOrganizationCompany,
        public array|null  $tags,
        public int|null    $templateLine,
        public string|null $unmappedMetrixCutterOperations,
    )
    {
        //
    }

}
