<?php

namespace Ptb\Pace\Models;

use Carbon\Carbon;
use Ptb\Pace\Castables\ToCarbon;
use Ptb\Pace\Query\Queryable;
use Ptb\Pace\Transformers\AsCarbon;
use Spatie\LaravelData\Attributes\WithCastable;
use Spatie\LaravelData\Attributes\WithTransformer;
use Spatie\LaravelData\Data;

class EstimatePart extends Data
{
    use Queryable;

    public function __construct(
        public int|null    $numPages,
        public string|null $additionalDescription,
        public int|null    $allowableOvers,
        public mixed       $availableManufacturingLocations,
        public bool|null   $bindingMethodChanged,
        public string|null $bindingSide,
        public float|null  $bleedsFace,
        public float|null  $bleedsFoot,
        public float|null  $bleedsHead,
        public float|null  $bleedsSpine,
        public int|null    $calcCompose,
        public int|null    $calcStepRepeat,
        public mixed       $certificationAuthority,
        public mixed       $certificationLevel,
        public float|null  $chargeableMakereadyPercent,
        public mixed       $coating,
        public bool|null   $coatingChanged,
        public int|null    $coatingSides,
        public string|null $collateOnPrinter,
        public int|null    $colorsSide1,
        public int|null    $colorsSide2,
        public int|null    $colorsTotal,
        public string|null $componentDescription,
        public float|null  $contourPerimeter,
        public mixed       $contourPerimeterUOM,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $convertDate,
        public string|null $description,
        public mixed       $difficulty,
        public bool|null   $eachOfPricing,
        public mixed       $estimate,
        public mixed       $estimateProduct,
        public float|null  $finalSizeHeight,
        public mixed       $finalSizeHeightDisplayUOM,
        public float|null  $finalSizeWidth,
        public mixed       $finalSizeWidthDisplayUOM,
        public mixed       $bindingMethod,
        public float|null  $flatSizeHeight,
        public mixed       $flatSizeHeightDisplayUOM,
        public float|null  $flatSizeWidth,
        public mixed       $flatSizeWidthDisplayUOM,
        public int|null    $foldPattern,
        public mixed       $foldPatternKey,
        public bool|null   $fromComposite,
        public bool|null   $gangable,
        public int|null    $grainSpecifications,
        public mixed       $id,
        public bool|null   $includeMailing,
        public bool|null   $inkChanged,
        public int|null    $inkCoverageBack,
        public float|null  $inkCoverageBackSpecify,
        public int|null    $inkCoverageFront,
        public float|null  $inkCoverageFrontSpecify,
        public int|null    $inkType,
        public string|null $ioID,
        public bool|null   $isOneWebOnly,
        public float|null  $itemDiscountPercent,
        public bool|null   $itemDiscountPercentForced,
        public mixed       $itemProductCondition,
        public mixed       $jobProductType,
        public string|null $jogSide,
        public float|null  $jogTrim,
        public mixed       $jogTrimDisplayUOM,
        #[WithCastable(ToCarbon::class)]
        public Carbon|null $lastModified,
        public int|null    $lastQuantityConverted,
        public bool|null   $manualOversAndWaste,
        public int|null    $manualWaste,
        public mixed       $manufacturingLocation,
        public float|null  $marginBottom,
        public mixed       $marginBottomDisplayUOM,
        public float|null  $marginRight,
        public mixed       $marginRightDisplayUOM,
        public string|null $metrixComponentID,
        public bool|null   $metrixEnabled,
        public mixed       $metrixFinishingGroupIds,
        public string|null $metrixID,
        public float|null  $nonImageFace,
        public mixed       $nonImageFaceDisplayUOM,
        public float|null  $nonImageFoot,
        public mixed       $nonImageFootDisplayUOM,
        public float|null  $nonImageHead,
        public mixed       $nonImageHeadDisplayUOM,
        public float|null  $nonImageSpine,
        public mixed       $nonImageSpineDisplayUOM,
        public string|null $notes,
        public int|null    $numColorChanges,
        public int|null    $numOddPanelsSpine,
        public int|null    $numOddPanelsWidth,
        public int|null    $numPlies,
        public int|null    $numShortPanelsSpine,
        public int|null    $numShortPanelsWidth,
        public int|null    $numSigs,
        public float|null  $oddPanelSpineSize,
        public float|null  $oddPanelWidthSize,
        public float|null  $outsidePurchaseMarkup,
        public bool|null   $outsidePurchaseMarkupForced,
        public mixed       $outsidePurchaseWorkflow,
        public bool|null   $outsidePurchaseWorkflowChanged,
        public string|null $pageDelivery,
        public mixed       $patternCategory,
        public mixed       $prepressWorkflow,
        public bool|null   $prepressWorkfkowChanged,
        public mixed       $pressEventWorkflow,
        public bool|null   $pressEventWorkflowChanged,
        public mixed       $pressInkType,
        public mixed       $priceLevel,
        public bool|null   $priceLevelForced,
        public mixed       $priceList,
        public mixed       $pricingUOM,
        public bool|null   $primaryPressChanged,
        public mixed       $certificationProductClassification,
        public mixed       $productType,
        public bool|null   $productTypeChanged,
        public mixed       $productionType,
        public string|null $quantities,
        public int|null    $quantity,
        public string|null $readingDirection,
        public int|null    $registerSide1,
        public int|null    $registerSide2,
        public bool|null   $requiresImposition,
        public int|null    $resolution,
        public mixed       $salesCategory,
        public string|null $seamDirection,
        public bool|null   $secondWeb,
        public bool|null   $separateLayout,
        public float|null  $sequence,
        public mixed       $shippingWorkflow,
        public bool|null   $shippingWorkflowChanged,
        public int|null    $shortPageDimension,
        public mixed       $sourceOrganizationCompany,
        public mixed       $speedFactor,
        public int|null    $bleedsAlong,
        public float|null  $spineSize,
        public bool|null   $suppressZeroPricedItems,
        public float|null  $tabFace,
        public float|null  $tabFoot,
        public float|null  $tabHead,
        public float|null  $tabSpine,
        public array|null  $tags,
        public mixed       $taxCategory,
        public int|null    $templateLine,
        public bool|null   $tileProduct,
        public int|null    $totalCoverPages,
        public int|null    $totalPages,
        public int|null    $totalTextPages,
        public float|null  $trimFace,
        public float|null  $trimFoot,
        public float|null  $trimHead,
        public float|null  $trimSizeHeight,
        public mixed       $trimSizeHeightDisplayUOM,
        public float|null  $trimSizeWidth,
        public mixed       $trimSizeWidthDisplayUOM,
        public float|null  $trimSpine,
        public bool|null   $usePriceListPricing,
        public mixed       $userInterfaceSet,
        public mixed       $varnish,
        public bool|null   $varnishChanged,
        public bool|null   $varnishDry,
        public int|null    $varnishSides,
        public mixed       $virtualPrinter,
        public float|null  $visualOpeningFace,
        public float|null  $visualOpeningFoot,
        public float|null  $visualOpeningHead,
        public float|null  $visualOpeningSizeHeight,
        public float|null  $visualOpeningSizeWidth,
        public float|null  $visualOpeningSpine,
        public float|null  $weight,
        public int|null    $bleedsAcross,
    )
    {
        //
    }

}
