<?php

namespace Ptb\Pace\Models;

use Carbon\Carbon;
use Ptb\Pace\Castables\ToCarbon;
use Ptb\Pace\Query\Queryable;
use Ptb\Pace\Transformers\AsCarbon;
use Spatie\LaravelData\Attributes\WithCastable;
use Spatie\LaravelData\Attributes\WithTransformer;
use Spatie\LaravelData\Data;

class Department extends Data
{
    use Queryable;

    public function __construct(
        public int|null    $accessPreviousShift,
        public bool|null   $active,
        public bool|null   $allowConcurrentEntries,
        public bool|null   $allowEntryCloning,
        public bool|null   $allowGanging,
        public bool|null   $allowOverlapping,
        public bool|null   $allowPausing,
        public bool|null   $allowQueries,
        public bool|null   $allowReports,
        public bool|null   $askJobComponent,
        public bool|null   $askJobMaterialID,
        public bool|null   $askJobPlanID,
        public bool|null   $askNonPlannedReason,
        public bool|null   $askPayRate,
        public bool|null   $askShift,
        public bool|null   $availableInShippingApp,
        public int|null    $beginningDayOfWeek,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $beginningTimeOfDay,
        public bool|null   $completeRuns,
        public mixed       $departmentManager,
        public string|null $description,
        public bool|null   $displayClosedJobs,
        public bool|null   $displayEmployeeTime,
        public bool|null   $displayJobPlanning,
        public bool|null   $displayMaterials,
        public bool|null   $displayNonChargeableTime,
        public int|null    $employeeTimeEarlyBuffer,
        public int|null    $employeeTimeLateBuffer,
        public int|null    $employeeTimeRounding,
        public mixed       $glDepartment,
        public mixed       $id,
        public string|null $ioID,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lastModified,
        public mixed       $noteCategory,
        public bool|null   $operatorViewable,
        public bool|null   $pullMultipleMaterials,
        public int|null    $quickEntry,
        public mixed       $signOutReport,
        public mixed       $sourceOrganizationCompany,
        public array|null  $tags,
        public int|null    $templateLine,
        public bool|null   $useMaterials,
    )
    {
        //
    }

}
