<?php

namespace Ptb\Pace\Concerns;

use JsonException;
use Ptb\Pace\PaceRestConnector;
use Ptb\Pace\Query\Builder;
use Ptb\Pace\Requests\CreateObject;
use Ptb\Pace\Requests\ReadObject;
use Ptb\Pace\Requests\UpdateObject;
use Saloon\Exceptions\Request\FatalRequestException;
use Saloon\Exceptions\Request\RequestException;
use Saloon\Http\Response;
use Throwable;

trait InteractsWithApi
{

    /**
     * @return Builder
     */
    public static function query(): Builder
    {
        $reflection = new \ReflectionClass(static::class);

        return new Builder(
            objectName: $reflection->getShortName(),
            dataClass: static::class
        );
    }

    /**
     * @param mixed $primaryKey
     * @return mixed
     * @throws FatalRequestException
     * @throws RequestException
     * @throws Throwable
     */
    public static function find(mixed $primaryKey): static
    {
        return match (gettype($primaryKey)) {
            'string' => self::fromString($primaryKey),
            'integer' => self::fromString( (string) $primaryKey),
        };
    }

    /**
     * @param array $attributes
     * @return mixed
     * @throws FatalRequestException
     * @throws JsonException
     * @throws RequestException
     * @throws Throwable
     */
    public static function create(array $attributes = []): mixed
    {
        $reflection = new \ReflectionClass(static::class);

        $response = app(PaceRestConnector::class)->send(
            request: new CreateObject(
                type: $reflection->getShortName(),
                data: $attributes,
            )
        );

        if ($response->failed()) {
            dump($response->toException());
            $response->throw();
        }

        return static::from($response->json());
    }

    /**
     * @param array $attributes
     * @return mixed
     * @throws FatalRequestException
     * @throws JsonException
     * @throws RequestException
     * @throws Throwable
     */
    public static function update(array $attributes = []): mixed
    {
        if (! array_key_exists('id', $attributes)) {
            throw new \RuntimeException('Missing id attribute');
        }

        $reflection = new \ReflectionClass(static::class);

        $response = app(PaceRestConnector::class)->send(
            request: new UpdateObject(
                type: $reflection->getShortName(),
                data: $attributes,
            )
        );

        if ($response->failed()) {
            dump($response->toException());
            $response->throw();
        }

        return static::from($response->json());
    }

    public function save()
    {
        //
    }

    /**
     * @param string $primaryKey
     * @return static
     * @throws FatalRequestException
     * @throws RequestException
     * @throws Throwable
     */
    public static function fromString(string $primaryKey): static
    {
        $reflection = new \ReflectionClass(static::class);

        $response = app(PaceRestConnector::class)
            ->send(
                request: new ReadObject(type: $reflection->getSHortName(), primaryKey: $primaryKey)
            );

        if ($response->failed()) {
            $response->throw();
        }

        return self::fromResponse($response);
    }

    /**
     * @param Response $response
     * @return static
     * @throws JsonException
     */
    public static function fromResponse(Response $response): static
    {
        return static::from($response->json());
    }
}