<?php

namespace Ptb\Orderdesk\Requests;

use Illuminate\Support\Carbon;
use Saloon\Enums\Method;
use Saloon\Http\Request;

class GetOrders extends Request
{
    /**
     * Define the HTTP method
     *
     * @var Method
     */
    protected Method $method = Method::GET;

    /**
     * Define the endpoint for the request
     *
     * @return string
     */
    public function resolveEndpoint(): string
    {
        return '/orders';
    }

    /**
     * Define default query string for the request
     *
     * @return array
     */
    public function defaultQuery(): array
    {
        $query = [];

        if (!is_null($this->folderId)) {
            data_set($query, 'folder_id', $this->folderId);
        }

        if (!is_null($this->folderName)) {
            data_set($query, 'folder_name', $this->folderName);
        }

        if (!is_null($this->sourceId)) {
            data_set($query, 'source_id', $this->sourceId);
        }

        if (!is_null($this->sourceName)) {
            data_set($query, 'source_name', $this->sourceName);
        }

        if (!is_null($this->searchStartDateLocal)) {
            data_set($query, 'search_start_date_local', $this->searchStartDateLocal);
        }

        if (!is_null($this->searchEndDateLocal)) {
            data_set($query, 'search_end_date_local', $this->searchEndDateLocal);
        }

        if (!is_null($this->searchStartDate)) {
            data_set($query, 'search_start_date', $this->searchStartDate);
        }

        if (!is_null($this->searchEndDate)) {
            data_set($query, 'search_end_date', $this->searchEndDate);
        }

        if (!is_null($this->modifiedStartDate)) {
            data_set($query, 'modified_start_date', $this->modifiedStartDate);
        }

        if (!is_null($this->modifiedEndDate)) {
            data_set($query, 'modified_end_date', $this->modifiedEndDate);
        }

        if (!is_null($this->email)) {
            data_set($query, 'email', $this->email);
        }

        if (!is_null($this->customerId)) {
            data_set($query, 'customer_id', $this->customerId);
        }

        if (!is_null($this->customerFirstName)) {
            data_set($query, 'customer_first_name', $this->customerFirstName);
        }

        if (!is_null($this->customerLastName)) {
            data_set($query, 'customer_last_name', $this->customerLastName);
        }

        if (!is_null($this->customerCompany)) {
            data_set($query, 'customer_company', $this->customerCompany);
        }

        if (!is_null($this->customerAddress1)) {
            data_set($query, 'customer_address1', $this->customerAddress1);
        }

        if (!is_null($this->shippingFirstName)) {
            data_set($query, 'shipping_first_name', $this->shippingFirstName);
        }

        if (!is_null($this->shippingLastName)) {
            data_set($query, 'shipping_last_name', $this->shippingLastName);
        }

        if (!is_null($this->shippingCompany)) {
            data_set($query, 'shipping_company', $this->shippingCompany);
        }

        if (!is_null($this->shippingAddress1)) {
            data_set($query, 'shipping_address1', $this->shippingAddress1);
        }

        if (!is_null($this->customerPhone)) {
            data_set($query, 'customer_phone', $this->customerPhone);
        }

        if (!is_null($this->shippingPhone)) {
            data_set($query, 'shipping_phone', $this->shippingPhone);
        }

        if (!is_null($this->getOrderHistory)) {
            data_set($query, 'get_order_history', $this->getOrderHistory);
        }

        data_set($query, 'order_by', $this->orderBy);
        data_set($query, 'order', $this->order);
        data_set($query, 'limit', $this->limit);

        if (!is_null($this->offset)) {
            data_set($query, 'offset', $this->offset);
        }

        return $query;
    }

    /**
     * @param string|null $folderId
     * @param string|null $folderName
     * @param string|null $sourceId
     * @param string|null $sourceName
     * @param Carbon|null $searchStartDateLocal
     * @param Carbon|null $searchEndDateLocal
     * @param Carbon|null $searchStartDate
     * @param Carbon|null $searchEndDate
     * @param Carbon|null $modifiedStartDate
     * @param Carbon|null $modifiedEndDate
     * @param string|null $email
     * @param string|null $customerId
     * @param string|null $customerFirstName
     * @param string|null $customerLastName
     * @param string|null $customerCompany
     * @param string|null $customerAddress1
     * @param string|null $shippingFirstName
     * @param string|null $shippingLastName
     * @param string|null $shippingCompany
     * @param string|null $shippingAddress1
     * @param string|null $customerPhone
     * @param string|null $shippingPhone
     * @param bool|null $getOrderHistory
     * @param string $orderBy
     * @param string $order
     * @param int $limit
     * @param int|null $offset
     */
    public function __construct(
        private readonly ?string $folderId = null,
        private readonly ?string $folderName = null,
        private readonly ?string $sourceId = null,
        private readonly ?string $sourceName = null,
        private readonly ?Carbon $searchStartDateLocal = null,
        private readonly ?Carbon $searchEndDateLocal = null,
        private readonly ?Carbon $searchStartDate = null,
        private readonly ?Carbon $searchEndDate = null,
        private readonly ?Carbon $modifiedStartDate = null,
        private readonly ?Carbon $modifiedEndDate = null,
        private readonly ?string $email = null,
        private readonly ?string $customerId = null,
        private readonly ?string $customerFirstName = null,
        private readonly ?string $customerLastName = null,
        private readonly ?string $customerCompany = null,
        private readonly ?string $customerAddress1 = null,
        private readonly ?string $shippingFirstName = null,
        private readonly ?string $shippingLastName = null,
        private readonly ?string $shippingCompany = null,
        private readonly ?string $shippingAddress1 = null,
        private readonly ?string $customerPhone = null,
        private readonly ?string $shippingPhone = null,
        private readonly ?bool $getOrderHistory = null,
        private readonly string $orderBy = 'date_added',
        private readonly string $order = 'DESC',
        private readonly int $limit = 50,
        private readonly ?int $offset = null,
    )
    {}
}
