<?php

namespace Ptb\Orderdesk\Requests;

use Saloon\Enums\Method;
use Saloon\Http\Request;

class GetOrderShipment extends Request
{
    /**
     * Define the HTTP method
     *
     * @var Method
     */
    protected Method $method = Method::GET;

    /**
     * Define the endpoint for the request
     *
     * @return string
     */
    public function resolveEndpoint(): string
    {
        return "/orders/{$this->id}/shipments/{$this->shipId}";
    }

    /**
     * @param int $id
     * @param int $shipId
     */
    public function __construct(
        private readonly int $id,
        private readonly int $shipId,
    )
    {}
}
