<?php

namespace Ptb\Orderdesk\Requests;

use Saloon\Enums\Method;
use Saloon\Http\Request;

class GetInventoryItems extends Request
{
    /**
     * Define the HTTP method
     *
     * @var Method
     */
    protected Method $method = Method::GET;

    /**
     * Define the endpoint for the request
     *
     * @return string
     */
    public function resolveEndpoint(): string
    {
        return '/inventory-items';
    }

    /**
     * Define the default query string for the request
     *
     * @return array
     */
    public function defaultQuery(): array
    {
        $query = [];

        if (!is_null($this->id)) {
            data_set($query, 'id', $this->id);
        }

        if (!is_null($this->search)) {
            data_set($query, 'search', $this->search);
        }

        if (!is_null($this->name)) {
            data_set($query, 'name', $this->name);
        }

        if (!is_null($this->code)) {
            data_set($query, 'code', $this->code);
        }

        if (!is_null($this->metadata)) {
            data_set($query, 'metadata', $this->metadata);
        }

        if (!is_null($this->manufacturerSku)) {
            data_set($query, 'manufacturer_sku', $this->manufacturerSku);
        }

        if (!is_null($this->location)) {
            data_set($query, 'location', $this->location);
        }

        if (!is_null($this->updateSourceNot)) {
            data_set($query, 'update_source_not', $this->updateSourceNot);
        }

        if (!is_null($this->updateStartDate)) {
            data_set($query, 'update_start_date', $this->updateStartDate);
        }

        return $query;
    }

    /**
     * @param int|null $id
     * @param string|null $search
     * @param string|null $name
     * @param string|null $code
     * @param string|null $metadata
     * @param string|null $manufacturerSku
     * @param string|null $location
     * @param string|null $updateSourceNot
     * @param Carbon|null $updateStartDate
     */
    public function __construct(
        private readonly ?int $id = null,
        private readonly ?string $search = null,
        private readonly ?string $name = null,
        private readonly ?string $code = null,
        private readonly ?string $metadata = null,
        private readonly ?string $manufacturerSku = null,
        private readonly ?string $location = null,
        private readonly ?string $updateSourceNot = null,
        private readonly ?Carbon $updateStartDate = null,
    )
    {}
}
