<?php

namespace Ptb\Orderdesk\Requests;

use Saloon\Enums\Method;
use Saloon\Http\Request;

class GetInventoryItem extends Request
{
    /**
     * Define the HTTP method
     *
     * @var Method
     */
    protected Method $method = Method::GET;

    /**
     * Define the endpoint for the request
     *
     * @return string
     */
    public function resolveEndpoint(): string
    {
        return "/inventory-items/{$this->id}";
    }

    /**
     * @param int $id
     */
    public function __construct(
        private readonly int $id
    )
    {}
}
