<?php

namespace Ptb\Orderdesk\Requests;

use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

class CreateOrder extends Request implements HasBody
{
    use HasJsonBody;

    /**
     * Define the HTTP method
     *
     * @var Method
     */
    protected Method $method = Method::POST;

    /**
     * Define the endpoint for the request
     *
     * @return string
     */
    public function resolveEndpoint(): string
    {
        return '/orders';
    }

    /**
     * Define the efault body for the request
     *
     * @return array
     */
    public function defaultBody(): array
    {
        return array_merge($this->item, [
            'order_metadata' => [
                'ship_notify_url' => route('orderdesk.shipment-notification')
            ]
        ]);
    }

    /**
     * @param array $item
     */
    public function __construct(
        private readonly array $item
    )
    {}
}
