<?php

namespace Ptb\Orderdesk;

use Saloon\Http\Connector;
use Saloon\Traits\Plugins\AcceptsJson;

class OrderdeskConnector extends Connector
{
    use AcceptsJson;

    /**
     * The Base URL of the API
     *
     * @return string
     */
    public function resolveBaseUrl(): string
    {
        return 'https://app.orderdesk.me/api/v2';
    }

    /**
     * Default headers for every request
     *
     * @return string[]
     */
    protected function defaultHeaders(): array
    {
        return [
            'ORDERDESK-STORE-ID' => config('services.orderdesk.storeId'),
            'ORDERDESK-API-KEY' => config('services.orderdesk.key'),
        ];
    }

    /**
     * Default HTTP client options
     *
     * @return string[]
     */
    protected function defaultConfig(): array
    {
        return [];
    }
}
