<?php

namespace Ptb\Orderdesk\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Ptb\Orderdesk\Events\ShipmentNotificationEvent;

class ShipmentNotificationController extends Controller
{
    /**
     * @param Request $request
     * @return JsonResponse
     */
    public function __invoke(Request $request): JsonResponse
    {
        $shipment_notification_event = new ShipmentNotificationEvent(
            order: $request->json('order'),
            shipment: $request->json('shipment'),
        );

        event($shipment_notification_event);

        return response()->json(null);
    }
}
