<?php

namespace Ptb\Orderdesk\Events;

use Illuminate\Foundation\Events\Dispatchable;

class ShipmentNotificationEvent
{
    use Dispatchable;

    /**
     * @param array $order
     * @param array $shipment
     */
    public function __construct(
        private readonly array $order,
        private readonly array $shipment
    )
    {}

    /**
     * @return mixed
     */
    public function getSourceId(): mixed
    {
        return data_get($this->order, 'source_id');
    }

    /**
     * @return mixed
     */
    public function getTrackingNumber(): mixed
    {
        return data_get($this->shipment, 'tracking_number');
    }

    /**
     * @return mixed
     */
    public function getDateShipped(): mixed
    {
        return data_get($this->shipment, 'date_shipped');
    }
}
