<?php

namespace Ptb\OrderDesk\DataObjects;

use Exception;

class OrderItem
{
    /**
     * @param string $code
     * @param int $quantity
     * @param float $price
     * @param string|null $name
     * @param float|null $weight
     * @param string $deliveryType
     * @param string|null $categoryCode
     * @param array|null $variationList
     * @param array|null $metadata
     */
    public function __construct(
        public readonly string $code,
        public readonly int $quantity = 1,
        public readonly float $price = 0.00,
        public readonly ?string $name = null,
        public readonly ?float $weight = null,
        public readonly string $deliveryType = 'ship',
        public readonly ?string $categoryCode = null,
        public readonly ?array $variationList = null,
        public readonly ?array $metadata = null,
    )
    {}

    /**
     * @return array
     */
    public function toArray(): array
    {
        return array_filter([
            'name' => $this->name,
            'price' => $this->price,
            'quantity' => $this->quantity,
            'weight' => $this->weight,
            'code' => $this->code,
            'delivery_type' => $this->deliveryType,
            'category_code' => $this->categoryCode,
            'variation_list' => $this->variationList,
            'metadata' => $this->metadata
        ]);
    }
}