<?php

namespace Ptb\OrderDesk\DataObjects;

class Order
{
    /**
     * @param int $sourceId
     * @param string $dateAdded
     * @param string $dateUpdated
     * @param array $shipping
     * @param array $orderMetadata
     * @param array $orderItems
     * @param string $email
     * @param string $shippingMethod
     * @param float $shippingTotal
     * @param float|null $handlingTotal
     * @param float|null $taxTotal
     * @param array|null $customer
     * @param array|null $returnAddress
     * @param array|null $checkoutData
     */
    public function __construct(
        public readonly int $sourceId,
        public readonly string $dateAdded,
        public readonly string $dateUpdated,
        public readonly array $shipping,
        public readonly array $orderMetadata,
        public readonly array $orderItems,
        public readonly string $email,
        public readonly string $shippingMethod,
        public readonly float $shippingTotal,
        public readonly ?float $handlingTotal = null,
        public readonly ?float $taxTotal = null,
        public readonly ?array $customer = null,
        public readonly ?array $returnAddress = null,
        public readonly ?array $checkoutData = null,
    )
    {}

    /**
     * @return array
     */
    public function toArray(): array
    {
        return array_filter([
            'source_id' => $this->sourceId,
            'email' => $this->email,
            'shipping_method' => $this->shippingMethod,
            'shipping_total' => $this->shippingTotal,
            'handling_total' => $this->handlingTotal,
            'tax_total' => $this->taxTotal,
            'date_added' => $this->dateAdded,
            'date_updated' => $this->dateUpdated,
            'shipping' => $this->shipping,
            'customer' => $this->customer,
            'return_address' => $this->returnAddress,
            'checkout_data' => $this->checkoutData,
            'order_metadata' => $this->orderMetadata,
            'order_items' => $this->orderItems
        ]);
    }
}