<?php

namespace Ptb\OrderDesk\DataObjects;

class Address
{
    /**
     * @param string $address1
     * @param string $city
     * @param string $state
     * @param string $postalCode
     * @param string|null $firstName
     * @param string|null $lastName
     * @param string|null $companyName
     * @param string|null $address2
     * @param string|null $country
     * @param string|null $phone
     */
    public function __construct(
        public readonly string $address1,
        public readonly string $city,
        public readonly string $state,
        public readonly string $postalCode,
        public readonly ?string $firstName = null,
        public readonly ?string $lastName = null,
        public readonly ?string $companyName = null,
        public readonly ?string $address2 = null,
        public readonly ?string $country = null,
        public readonly ?string $phone = null,
    )
    {}

    /**
     * @return array
     */
    public function toArray(): array
    {
        return array_filter([
            'first_name' => $this->firstName,
            'last_name' => $this->lastName,
            'company' => $this->companyName,
            'address1' => $this->address1,
            'address2' => $this->address2,
            'city' => $this->city,
            'state' => $this->state,
            'postal_code' => $this->postalCode,
            'country' => $this->country,
            'phone' => $this->phone
        ]);
    }

}