<?php

namespace Ptb\Synapse;

use GuzzleHttp\Cookie\CookieJar;
use Ptb\Synapse\Contracts\WithCookies;
use Ptb\Synapse\Requests\LoginRequest;
use Saloon\Contracts\Authenticator;
use Saloon\Contracts\PendingRequest;

class SynapseAuthenticator implements Authenticator
{

    /**
     * Apply the authentication to the request.
     *
     * @param PendingRequest $pendingRequest
     * @return void
     */
    public function set(PendingRequest $pendingRequest): void
    {
        if ($pendingRequest->getRequest() instanceof LoginRequest) {
            return;
        }

        if ($pendingRequest->getConnector() instanceof WithCookies) {
            $cookies = $pendingRequest->getConnector()->getCookies();
            if (count($cookies) > 0) {
                $token = data_get($cookies, 'XSRF-TOKEN');
                $pendingRequest->config()->add('cookies', CookieJar::fromArray($cookies, 'pointb.zethconapp.com'));
                $pendingRequest->headers()->add('X-XSRF-TOKEN', $token);
            }
        }
    }
}
