<?php

namespace Ptb\Synapse\Requests;

use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

class CreateOrder extends Request implements HasBody
{
    use HasJsonBody;

    /**
     * Define the HTTP method
     *
     * @var Method
     */
    protected Method $method = Method::POST;

    /**
     * Define the endpoint for the request
     *
     * @return string
     */
    public function resolveEndpoint(): string
    {
        return '/orders/create-order';
    }

    /**
     * @return array
     */
    public function defaultBody(): array
    {
        return $this->data;
    }

    /**
     * @param array $data
     */
    public function __construct(
        private readonly array $data
    )
    {}
}
