<?php

namespace Ptb\Synapse\Requests;

use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

class GetOrderLabels extends Request implements HasBody
{
    use HasJsonBody;

    /**
     * Define the HTTP method
     *
     * @var Method
     */
    protected Method $method = Method::POST;

    /**
     * Define the endpoint for the request
     *
     * @return string
     */
    public function resolveEndpoint(): string
    {
        return '/labels/sscc';
    }

    /**
     * @return array
     */
    public function defaultBody(): array
    {
        return [
            'orderid' => $this->orderId,
            'shipid' => $this->shipId
        ];
    }

    /**
     * @param int $orderId
     * @param int $shipId
     */
    public function __construct(
        private readonly int $orderId,
        private readonly int $shipId
    )
    {}
}
