<?php

namespace Ptb\Synapse\Requests;

use Illuminate\Support\Carbon;
use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

class GetCustomerShipments extends Request implements HasBody
{

    use HasJsonBody;

    /**
     * Define the HTTP method
     *
     * @var Method
     */
    protected Method $method = Method::POST;

    /**
     * Define the endpoint for the request
     *
     * @return string
     */
    public function resolveEndpoint(): string
    {
        return '/orders/shipped-orders';
    }

    /**
     * @return array
     */
    public function defaultBody(): array
    {
        return [
            'request_type' => 'range',
            'begin_date' => $this->beginDate->format('m/d/Y h:i:s'),
            'end_date' => $this->endDate->format('m/d/Y h:i:s'),
            'custid' => $this->customerId,
            'facility' => $this->facility
        ];
    }

    /**
     * @param string $customerId
     * @param Carbon $beginDate
     * @param Carbon $endDate
     * @param string $facility
     */
    public function __construct(
        private readonly string $customerId,
        private readonly Carbon $beginDate,
        private readonly Carbon $endDate,
        private readonly string $facility,
    )
    {}
}
