<?php

namespace Ptb\Synapse;

use Ptb\Synapse\Auth\SynapseAuthenticator;
use Ptb\Synapse\Requests\LoginRequest;
use Ptb\Synapse\Requests\LogoutRequest;
use Ptb\Synapse\Resources\InventoryResource;
use Ptb\Synapse\Resources\OrderResource;
use Ptb\Synapse\Resources\ShipmentResource;
use ReflectionException;
use Saloon\Contracts\Authenticator;
use Saloon\Contracts\Response;
use Saloon\Exceptions\InvalidResponseClassException;
use Saloon\Exceptions\PendingRequestException;
use Saloon\Http\Connector;
use Saloon\Traits\Plugins\AcceptsJson;

class SynapseConnector extends Connector implements WithCookies
{
    use AcceptsJson;
    use HasCookies;

    protected array $cookies = [];

    /**
     * The Base URL of the API
     *
     * @return string
     */
    public function resolveBaseUrl(): string
    {
        return config('synapse.baseUrl');
    }

    /**
     * Default headers for every request
     *
     * @return string[]
     */
    protected function defaultHeaders(): array
    {
        return [];
    }

    /**
     * Default HTTP client options
     *
     * @return string[]
     */
    protected function defaultConfig(): array
    {
        return [];
    }

    /**
     * @return Authenticator|null
     */
    protected function defaultAuth(): ?Authenticator
    {
        return new SynapseAuthenticator();
    }

    /**
     * @return InventoryResource
     */
    public function inventory(): InventoryResource
    {
        return new InventoryResource($this);
    }


    /**
     * @return OrderResource
     */
    public function orders(): OrderResource
    {
        return new OrderResource($this);
    }

    /**
     * @return ShipmentResource
     */
    public function shipments(): ShipmentResource
    {
        return new ShipmentResource($this);
    }

    /**
     * @return Response
     * @throws ReflectionException
     * @throws InvalidResponseClassException
     * @throws PendingRequestException
     */
    public function login(): Response
    {
        return $this->send(
            request: new LoginRequest()
        );
    }

    /**
     * @return Response
     * @throws InvalidResponseClassException
     * @throws PendingRequestException
     * @throws ReflectionException
     */
    public function logout(): Response
    {
        return $this->send(
            request: new LogoutRequest()
        );
    }
}
