<?php

namespace Ptb\Synapse\Resources;

use App\Http\Integrations\Synapse\Requests\GetCustomerShipments;
use App\Http\Integrations\Synapse\Requests\GetOrderShipments;
use Illuminate\Support\Carbon;
use Ptb\Synapse\Requests\GetCustomerInventory;
use Ptb\Synapse\Requests\GetItemInventory;
use Ptb\Synapse\SynapseConnector;
use ReflectionException;
use Saloon\Contracts\Response;
use Saloon\Exceptions\InvalidResponseClassException;
use Saloon\Exceptions\PendingRequestException;

final class ShipmentResource
{
    public function __construct(
        private readonly SynapseConnector $connector
    )
    {}

    /**
     * @param string $customerId
     * @param string $facility
     * @param Carbon $beginDate
     * @param Carbon $endDate
     * @return Response
     * @throws InvalidResponseClassException
     * @throws PendingRequestException
     * @throws ReflectionException
     */
    public function byCustomer(string $customerId, string $facility, Carbon $beginDate, Carbon $endDate): Response
    {
        return $this->connector->send(
            request: new GetCustomerShipments(
                customerId: $customerId,
                beginDate: $beginDate,
                endDate: $endDate,
                facility: $facility
            )
        );
    }

    /**
     * @param string $customerId
     * @param string $facility
     * @param int $orderId
     * @param int $shipId
     * @return Response
     * @throws InvalidResponseClassException
     * @throws PendingRequestException
     * @throws ReflectionException
     */
    public function byOrder(string $customerId, string $facility, int $orderId, int $shipId = 1): Response
    {
        return $this->connector->send(
            request: new GetOrderShipments(
                customerId: $customerId,
                orderId: $orderId,
                shipId: $shipId,
                facility: $facility
            )
        );
    }
}