<?php

namespace Ptb\Synapse\Requests;

use Saloon\Contracts\Body\HasBody;
use Saloon\Contracts\PendingRequest;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

class GetOrderInfo extends Request implements HasBody
{
    use HasJsonBody;

    /**
     * Define the HTTP method
     *
     * @var Method
     */
    protected Method $method = Method::POST;

    /**
     * Define the endpoint for the request
     *
     * @return string
     */
    public function resolveEndpoint(): string
    {
        return '/orders/order-info';
    }

    /**
     * @return array
     */
    public function defaultBody(): array
    {
        return [
            'orderid' => $this->orderId,
            'shipid' => $this->shipId,
        ];
    }

    /**
     * @param int $orderId
     * @param int $shipId
     */
    public function __construct(
        private readonly int $orderId,
        private readonly int $shipId,
    )
    {}
}
