<?php

namespace Ptb\Synapse;

use Illuminate\Support\ServiceProvider;

class PackageServiceProvider extends ServiceProvider
{

    /**
     * Register any application services
     *
     * @return void
     */
    public function register(): void
    {

    }

    /**
     * Bootstrap any application services
     *
     * @return void
     */
    public function boot(): void
    {

        $this->mergeConfigFrom(
            path: __DIR__ . '/../config/synapse.php',
            key: 'synapse'
        );

        $this->publishes([
            __DIR__ . '/../config/synapse.php' => config_path('synapse.php'),
        ]);

        $this->commands([
            Console\InstallCommand::class,
        ]);
    }

    /**
     * Get the services provided by the provider
     *
     * @return string[]
     */
    public function provides(): array
    {
        return [
            Console\InstallCommand::class,
        ];
    }
}
