<?php

namespace Ptb\Synapse\Resources;

use Ptb\Synapse\Requests\GetCustomerInventory;
use Ptb\Synapse\Requests\GetItemInventory;
use Ptb\Synapse\SynapseConnector;
use ReflectionException;
use Saloon\Contracts\Response;
use Saloon\Exceptions\InvalidResponseClassException;
use Saloon\Exceptions\PendingRequestException;

final class InventoryResource
{
    public function __construct(
        private readonly SynapseConnector $connector
    )
    {}

    /**
     * @param string $customerId
     * @param string $facility
     * @return Response
     * @throws ReflectionException
     * @throws InvalidResponseClassException
     * @throws PendingRequestException
     */
    public function byCustomer(string $customerId, string $facility): Response
    {
        return $this->connector->send(
            request: new GetCustomerInventory(
                customerId: $customerId,
                facility: $facility
            )
        );
    }

    /**
     * @param string $customerId
     * @param string $facility
     * @param string $sku
     * @return Response
     * @throws InvalidResponseClassException
     * @throws PendingRequestException
     * @throws ReflectionException
     */
    public function byItem(string $customerId, string $facility, string $sku): Response
    {
        return $this->connector->send(
            request: new GetItemInventory(
                customerId: $customerId,
                sku: $sku,
                facility: $facility
            )
        );
    }
}