<?php

namespace Ptb\Saml2\Tests\Feature;

use Ptb\Saml2\Tests\TestCase;
use Mockery;

class Saml2Test extends TestCase
{
    public function testRedirectsToIdp()
    {
        $response = $this->get('/');
        $response->assertStatus(302);
    }

    public function testGetIntendedUrl()
    {
        $intendedUrl = 'https://something.net';

        $auth = Mockery::mock(AuthProvider::class);
        $auth->shouldReceive('getIntendedUrl')->andReturn($intendedUrl);

        $authProvider = new AuthProvider();
        app('request')->merge([
            'RelayState' => $intendedUrl
        ]);

        $this->assertEquals($intendedUrl, $authProvider->getIntendedUrl());
    }

}