<?php

namespace App\Http\Integrations\Synapse\Requests;

use App\Http\Integrations\Contracts\WithCookies;
use Saloon\Contracts\Body\HasBody;
use Saloon\Contracts\Response;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

class LoginRequest extends Request implements HasBody
{
    use HasJsonBody;

    /**
     * Define the HTTP method
     *
     * @var Method
     */
    protected Method $method = Method::POST;

    /**
     * Define the endpoint for the request
     *
     * @return string
     */
    public function resolveEndpoint(): string
    {
        return '/login';
    }

    /**
     * @return array
     */
    public function defaultConfig(): array
    {
        return [
            'isAuth' => true,
        ];
    }

    /**
     * @return array
     */
    public function defaultBody(): array
    {
        return [
            'username' => config('services.zethcon.username'),
            'password' => config('services.zethcon.password'),
        ];
    }

    /**
     *
     */
    public function __construct()
    {
        $this->middleware()->onResponse(function (Response $response) {
            $connector = $response->getPendingRequest()->getConnector();
            if ($connector instanceof WithCookies) {
                $cookies = $response->headers()->get('set-cookie');
                foreach ($cookies as $cookie) {
                    $name = substr($cookie, 0, stripos($cookie, '=', 1));
                    $value = substr($cookie, stripos($cookie, '=', 1) + 1);
                    $value = substr($value, 0, stripos($value, ';', 1));
                    $connector->setCookie($name, $value);
                }
            }
        });
    }
}
