<?php

namespace App\Http\Integrations\Synapse\Requests;

use Illuminate\Support\Carbon;
use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

class GetOrderShipments extends Request implements HasBody
{
    use HasJsonBody;

    /**
     * Define the HTTP method
     *
     * @var Method
     */
    protected Method $method = Method::POST;

    /**
     * Define the endpoint for the request
     *
     * @return string
     */
    public function resolveEndpoint(): string
    {
        return '/orders/shipped-orders';
    }

    public function defaultBody(): array
    {
        return [
            'request_type' => 'order',
            'orderid' => $this->orderId,
            'shipid' => $this->shipId,
            'custid' => $this->customerId,
            'facility' => $this->facility
        ];
    }

    public function __construct(
        private readonly string $customerId,
        private readonly int $orderId,
        private readonly int $shipId,
        private readonly string $facility,
    )
    {}
}
