<?php

namespace Ptb\Synapse\Requests;

use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

class GetCustomerInventory extends Request implements HasBody
{
    use HasJsonBody;

    /**
     * Define the HTTP method
     *
     * @var Method
     */
    protected Method $method = Method::POST;

    /**
     * Define the endpoint for the request
     *
     * @return string
     */
    public function resolveEndpoint(): string
    {
        return '/inventory/by-customer';
    }

    /**
     * @return array
     */
    public function defaultBody(): array
    {
        return [
            'custid' => $this->customerId,
            'facility' => $this->facility,
        ];
    }

    /**
     * @param string $customerId
     * @param string $facility
     */
    public function __construct(
        private readonly string $customerId,
        private readonly string $facility
    )
    {}
}
