<?php

namespace Ptb\Saml2;

use Illuminate\Support\ServiceProvider;

class PackageServiceProvider extends ServiceProvider
{

    /**
     * Register any application services
     *
     * @return void
     */
    public function register(): void
    {

    }

    /**
     * Bootstrap any application services
     *
     * @return void
     */
    public function boot(): void
    {
        $this->loadRoutesFrom(
            path: __DIR__ . '/../routes/saml2.php'
        );

        $this->mergeConfigFrom(
            path: __DIR__ . '/../config/saml2.php',
            key: 'saml2'
        );

        $this->publishes([
            __DIR__ . '/../config/saml2.php' => config_path('saml2.php'),
        ]);

        $this->commands([
            Console\InstallCommand::class,
        ]);
    }

    /**
     * Get the services provided by the provider
     *
     * @return string[]
     */
    public function provides(): array
    {
        return [
            Console\InstallCommand::class,
        ];
    }
}
