<?php

return [
    'enabled' => env('SAML2_ENABLED', false),

    // Indicates how the parameters will be
    // retrieved from the sls request for signature validation
    'retrieveParametersFromServer' => false,

    // Where to redirect after logout
    'logoutRoute' =>  env('SAML2_LOGOUT_ROUTE', 'home'),

    // Where to redirect after login if no other option was provided
    'loginRoute' => env('SAML2_LOGIN_ROUTE', 'home'),

    // Where to redirect after login if no other option was provided
    'errorRoute' => env('SAML2_ERROR_ROUTE', 'home'),

    // If 'proxyVars' is True, then the Saml lib will trust proxy headers
    // e.g X-Forwarded-Proto / HTTP_X_FORWARDED_PROTO. This is useful if
    // your application is running behind a load balancer which terminates
    // SSL.
    'proxyVars' => true,

    // (Optional) Which class implements the route functions.
    // 'saml2_controller' => '',

    // If 'strict' is True, then the PHP Toolkit will reject unsigned
    // or unencrypted messages if it expects them signed or encrypted
    // Also will reject the messages if not strictly follow the SAML
    // standard: Destination, NameId, Conditions ... are validated too.
    'strict' => true, //@todo: make this depend on laravel config

    // Enable debug mode (to print errors)
    'debug' => env('APP_DEBUG', false),

    // Service Provider Data that we are deploying
    'sp' => array(
        // Specifies constraints on the name identifier to be used to
        // represent the requested subject.
        // Take a look on lib/Saml2/Constants.php to see the NameIdFormat supported
        'NameIDFormat' => 'urn:oasis:names:tc:SAML:2.0:nameid-format:persistent',

        // Usually x509cert and privateKey of the SP are provided by files placed at
        // the certs folder. But we can also provide them with the following parameters
        'x509cert' => env('SAML2_SP_x509', 'MIICbjCCAdegAwIBAgIBADANBgkqhkiG9w0BAQ0FADBUMQswCQYDVQQGEwJ1czELMAkGA1UECAwCTU4xGjAYBgNVBAoMEVBvaW50IEIgU29sdXRpb25zMRwwGgYDVQQDDBNwb2ludGJzb2x1dGlvbnMuY29tMB4XDTIyMDIwODIyMTgwN1oXDTIzMDIwODIyMTgwN1owVDELMAkGA1UEBhMCdXMxCzAJBgNVBAgMAk1OMRowGAYDVQQKDBFQb2ludCBCIFNvbHV0aW9uczEcMBoGA1UEAwwTcG9pbnRic29sdXRpb25zLmNvbTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEA7OIgLYsu9JioW3x5ihH6kJb3wK/T+S0kn/xWughO2hybU1dCJvczijItvKNNjcQU7TD+ruGq+IVrAJGVZ6RiYnbnUWoAmMlKnVXfKfst603r5g22iAehoijZK1OoyWoZo9faA83HkVfINk3OXLHGtRJX98Arlu5t5jg6WAxtDAECAwEAAaNQME4wHQYDVR0OBBYEFN91BVWluh9jVr6S2cuq5Gub3XdkMB8GA1UdIwQYMBaAFN91BVWluh9jVr6S2cuq5Gub3XdkMAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQENBQADgYEABoyzPEjPzdAQNytPHng/szmYDgExFlgYheevZ6685BdoUfipbkke9Z4fceLzLgPDcNuJReD4AY2taR3aprvvWWvcEMVl7i0GjwtpZV5B7gCzILtCo6PgQOMLH4aUq6s9j2UCmqxbbZlU26Tp1hrK2MX4BL644io8gDShNjML5gU=
'),
        'privateKey' => env('SAML2_SP_PRIVATE_KEY', 'MIICeAIBADANBgkqhkiG9w0BAQEFAASCAmIwggJeAgEAAoGBAOziIC2LLvSYqFt8eYoR+pCW98Cv0/ktJJ/8VroITtocm1NXQib3M4oyLbyjTY3EFO0w/q7hqviFawCRlWekYmJ251FqAJjJSp1V3yn7LetN6+YNtogHoaIo2StTqMlqGaPX2gPNx5FXyDZNzlyxxrUSV/fAK5bubeY4OlgMbQwBAgMBAAECgYEAr5w/sKPTTp9xiEkyLSqA7/oLd7yhz8MouLYwcT/BfS7h85nnv81ZVyU2BPengeaQgPrmhC1mO1Flbwl+klQqXll9isHEEvEUwb20f6EF2er4Zl9NVMgxj3XZD9cOANhoJYTBHQNTg+9zB05MzTOVRKvkRVwmhSkuAxJMI5aQ2zECQQD8bx75AfvTj+JycWvFZfBhmh06mctWtGyJEnW98M0PY1Uzr9TYPemhloWBUtGNWj4F9gfmMnT1UXwOHHg+SgadAkEA8DrEtITp9OdcQgYbt+Tpx0KWJzQhqmrdKKY3YNwYdShqYjlGgSaUHFtwaehLobBuFbLb0kKDmHgfUgNp0MIrtQJBAL2lbgt9JggnTOTVuTWwBAwPkG36JP2axv+j0rlEM4qgAd629p0OxnsTbnFeGvirF3W7BOw4dA3pjd28HcoOKzECQQCkgaoYcHiCJDlSYTp0CMdqk5edix6OxBVk88YyhyYcfKu1TcGRSajdbmShsdixBc+s/kl4R+Iz8/aGxB2fPoiNAkB5ee2RNLg2YUJoqGfXBuL0jeufOdnbrY11evjzIwdiRDP+xNNfe5/s1Bv5BYYa1asLsSjefN3RICVuTXC5CIHu'),

        // Identifier (URI) of the SP entity.
        // Leave blank to use the '{idpName}_metadata' route, e.g. 'test_metadata'.
        'entityId' => env('SAML2_SP_ENTITY_ID', 'http://localhost'),

        // Specifies info about where and how the <AuthnResponse> message MUST be
        // returned to the requester, in this case our SP.
        'assertionConsumerService' => array(
            // URL Location where the <Response> from the IdP will be returned,
            // using HTTP-POST binding.
            'url' => env('SAML2_SP_ACS_ROUTE', 'saml2.acs'),
        ),
        // Specifies info about where and how the <Logout Response> message MUST be
        // returned to the requester, in this case our SP.
        // Remove this part to not include any URL Location in the metadata.
        'singleLogoutService' => array(
            // URL Location where the <Response> from the IdP will be returned,
            // using HTTP-Redirect binding.
            'url' => env('SAML2_SP_SLS_ROUTE', 'saml2.sls'),
        ),
    ),

    // Identity Provider Data that we want to connect with our SP
    'idp' => array(
        // Identifier of the IdP entity  (must be a URI)
        'entityId' => env('SAML2_IDP_ENTITY_ID', 'https://samltest.id/saml/idp'),
        // SSO endpoint info of the IdP. (Authentication Request protocol)
        'singleSignOnService' => array(
            // URL Target of the IdP where the SP will send the Authentication Request Message,
            // using HTTP-Redirect binding.
            'url' => env('SAML2_IDP_SSO_URL', 'https://samltest.id/idp/profile/SAML2/Redirect/SSO'),
        ),
        // SLO endpoint info of the IdP.
        'singleLogoutService' => array(
            // URL Location of the IdP where the SP will send the SLO Request,
            // using HTTP-Redirect binding.
            'url' => env('SAML2_IDP_SL_URL', ''),
        ),
        // Public x509 certificate of the IdP
        'x509cert' => env('SAML2_IDP_x509', 'MIIDEjCCAfqgAwIBAgIVAMECQ1tjghafm5OxWDh9hwZfxthWMA0GCSqGSIb3DQEBCwUAMBYxFDASBgNVBAMMC3NhbWx0ZXN0LmlkMB4XDTE4MDgyNDIxMTQwOVoXDTM4MDgyNDIxMTQwOVowFjEUMBIGA1UEAwwLc2FtbHRlc3QuaWQwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQC0Z4QX1NFKs71ufbQwoQoW7qkNAJRIANGA4iM0ThYghul3pC+FwrGv37aTxWXfA1UG9njKbbDreiDAZKngCgyjxj0uJ4lArgkr4AOEjj5zXA81uGHARfUBctvQcsZpBIxDOvUUImAl+3NqLgMGF2fktxMG7kX3GEVNc1klbN3dfYsaw5dUrw25DheL9np7G/+28GwHPvLb4aptOiONbCaVvh9UMHEA9F7c0zfF/cL5fOpdVa54wTI0u12CsFKt78h6lEGG5jUs/qX9clZncJM7EFkN3imPPy+0HC8nspXiH/MZW8o2cqWRkrw3MzBZW3Ojk5nQj40V6NUbjb7kfejzAgMBAAGjVzBVMB0GA1UdDgQWBBQT6Y9J3Tw/hOGc8PNV7JEE4k2ZNTA0BgNVHREELTArggtzYW1sdGVzdC5pZIYcaHR0cHM6Ly9zYW1sdGVzdC5pZC9zYW1sL2lkcDANBgkqhkiG9w0BAQsFAAOCAQEASk3guKfTkVhEaIVvxEPNR2w3vWt3fwmwJCccW98XXLWgNbu3YaMb2RSn7Th4p3h+mfyk2don6au7Uyzc1Jd39RNv80TG5iQoxfCgphy1FYmmdaSfO8wvDtHTTNiLArAxOYtzfYbzb5QrNNH/gQEN8RJaEf/g/1GTw9x/103dSMK0RXtl+fRs2nblD1JJKSQ3AdhxK/weP3aUPtLxVVJ9wMOQOfcy02l+hHMb6uAjsPOpOVKqi3M8XmcUZOpx4swtgGdeoSpeRyrtMvRwdcciNBp9UZome44qZAYH1iqrpmmjsfI9pJItsgWu3kXPjhSfj1AJGR1l9JGvJrHki1iHTA=='),
        /*
         *  Instead of use the whole x509cert you can use a fingerprint
         *  (openssl x509 -noout -fingerprint -in "idp.crt" to generate it)
         */
        // 'certFingerprint' => '',

        /**
         * (Optional) Enable Multi-Cert signing/encryption
         * In some scenarios the IdP uses different certificates for
         * signing/encryption, or is under key rollover phase and
         * more than one certificate is published on IdP metadata.
         * In order to handle that the toolkit offers that parameter.
         * (when used, 'x509cert' and 'certFingerprint' values are
         * ignored).
         */

        //'x509certMulti'=>array(
        //    'signing'=>array(
        //      0=>env('SAML2_'.$this_idp_env_id.'_IDP_x509_SIGNING_0',''),
        //    ),
        //    'encryption'=>array(
        //      0=>env('SAML2_'.$this_idp_env_id.'_IDP_x509_ENCRYPTION_0',''),
        //    ),
        //  ),

        'attributeMap' => array(
            'Company Name' => 'extra_fields.company_name',
            'http://schemas.microsoft.com/ws/2008/06/identity/claims/groups' => 'roles',
            'http://schemas.microsoft.com/identity/claims/objectidentifier' => 'password',
            'Email Address' => 'email',
            'givenname' => 'first_name',
            'surname' => 'last_name',
            'Office' => 'extra_fields.office',
            'Department' => 'extra_fields.department'
        ),
    ),

    // Security settings
    'security' => array(
        // Indicates that the nameID of the <samlp:logoutRequest> sent by this SP
        // will be encrypted.
        'nameIdEncrypted' => false,

        // Indicates whether the <samlp:AuthnRequest> messages sent by this SP
        // will be signed.              [The Metadata of the SP will offer this info]
        'authnRequestsSigned' => false,

        // Indicates whether the <samlp:logoutRequest> messages sent by this SP
        // will be signed.
        'logoutRequestSigned' => false,

        // Indicates whether the <samlp:logoutResponse> messages sent by this SP
        // will be signed.
        'logoutResponseSigned' => false,

        // Sign the Metadata
        // False || True (use sp certs) || array (
        //                                            keyFileName => 'metadata.key',
        //                                            certFileName => 'metadata.crt'
        //                                        )
        //
        'signMetadata' => false,

        // Indicates a requirement for the <samlp:Response>, <samlp:LogoutRequest> and
        // <samlp:LogoutResponse> elements received by this SP to be signed.
        'wantMessagesSigned' => false,

        // Indicates a requirement for the <saml:Assertion> elements received by
        // this SP to be signed.        [The Metadata of the SP will offer this info]
        'wantAssertionsSigned' => false,

        // Indicates a requirement for the NameID received by
        // this SP to be encrypted.
        'wantNameIdEncrypted' => false,

        // Authentication context.
        // Set to false and no AuthContext will be sent in the AuthNRequest,
        // Set true or don't present thi parameter and you will get an AuthContext 'exact' 'urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport'
        // Set an array with the possible auth context values: array ('urn:oasis:names:tc:SAML:2.0:ac:classes:Password', 'urn:oasis:names:tc:SAML:2.0:ac:classes:X509'),
        'requestedAuthnContext' => true,
    ),

    // Contact information template, it is recommended to suply a technical and support contacts
    'contactPerson' => array(
        'technical' => array(
            'givenName' => env('SAML2_TECHNICAL_NAME', 'Technical Contact'),
            'emailAddress' => env('SAML2_TECHNICAL_EMAIL', 'no@reply.com'),
        ),
        'support' => array(
            'givenName' => env('SAML2_SUPPORT_NAME', 'Support'),
            'emailAddress' => env('SAML2_SUPPORT_EMAIL', 'no@reply.com'),
        ),
    ),

    // Organization information template, the info in en_US lang is recomended, add more if required
    'organization' => array(
        'en-US' => array(
            'name' => env('SAML2_ORG_NAME', 'Laravel'),
            'displayname' => env('SAML2_ORG_DISPLAY_NAME', 'Laravel'),
            'url' => env('SAML2_ORG_URL', 'http://localhost')
        ),
    ),

    /* Interoperable SAML 2.0 Web Browser SSO Profile [saml2int]   http://saml2int.org/profile/current
       'authnRequestsSigned' => false,    // SP SHOULD NOT sign the <samlp:AuthnRequest>,
                                          // MUST NOT assume that the IdP validates the sign
       'wantAssertionsSigned' => true,
       'wantAssertionsEncrypted' => true, // MUST be enabled if SSL/HTTPs is disabled
       'wantNameIdEncrypted' => false,
    */
];
