<?php

namespace Ptb\OrderDesk\Transformers;

class OrderTransformer
{
    protected int $sourceId;
    protected string $email;
    protected string $shippingMethod;
    protected float $shippingTotal;
    protected ?float $handlingTotal;
    protected ?float $taxTotal;
    protected string $dateAdded;
    protected string $dateUpdated;
    protected array $shipping;
    protected ?array $customer;
    protected ?array $returnAddress;
    protected ?array $checkoutData;
    protected array $orderMetadata;
    protected array $orderItems;

    public function __construct()
    {
        $this->sourceId = 0;
        $this->shippingMethod = '';
        $this->shippingTotal = 0.00;
        $this->handlingTotal = null;
        $this->taxTotal = null;
        $this->dateAdded = now()->format('Y-m-d h:i:s');
        $this->dateUpdated = now()->format('Y-m-d h:i:s');
        $this->shipping = [];
        $this->customer = null;
        $this->returnAddress = null;
        $this->checkoutData = null;
        $this->orderMetadata = [];
        $this->orderItems = [];
    }

    /**
     * @return int
     */
    public function getSourceId(): int
    {
        return $this->sourceId;
    }

    /**
     * @param int $sourceId
     * @return OrderTransformer
     */
    public function setSourceId(int $sourceId): OrderTransformer
    {
        $this->sourceId = $sourceId;
        return $this;
    }

    /**
     * @return string
     */
    public function getEmail(): string
    {
        return $this->email;
    }

    /**
     * @param string $email
     * @return OrderTransformer
     */
    public function setEmail(string $email): OrderTransformer
    {
        $this->email = $email;
        return $this;
    }

    /**
     * @return string
     */
    public function getShippingMethod(): string
    {
        return $this->shippingMethod;
    }

    /**
     * @param string $shippingMethod
     * @return OrderTransformer
     */
    public function setShippingMethod(string $shippingMethod): OrderTransformer
    {
        $this->shippingMethod = $shippingMethod;
        return $this;
    }

    /**
     * @return float
     */
    public function getShippingTotal(): float
    {
        return $this->shippingTotal;
    }

    /**
     * @param float $shippingTotal
     * @return OrderTransformer
     */
    public function setShippingTotal(float $shippingTotal): OrderTransformer
    {
        $this->shippingTotal = $shippingTotal;
        return $this;
    }

    /**
     * @return float
     */
    public function getHandlingTotal(): float
    {
        return $this->handlingTotal;
    }

    /**
     * @param float $handlingTotal
     * @return OrderTransformer
     */
    public function setHandlingTotal(float $handlingTotal): OrderTransformer
    {
        $this->handlingTotal = $handlingTotal;
        return $this;
    }

    /**
     * @return float
     */
    public function getTaxTotal(): float
    {
        return $this->taxTotal;
    }

    /**
     * @param float $taxTotal
     * @return OrderTransformer
     */
    public function setTaxTotal(float $taxTotal): OrderTransformer
    {
        $this->taxTotal = $taxTotal;
        return $this;
    }

    /**
     * @return string
     */
    public function getDateAdded(): string
    {
        return $this->dateAdded;
    }

    /**
     * @param string $dateAdded
     * @return OrderTransformer
     */
    public function setDateAdded(string $dateAdded): OrderTransformer
    {
        $this->dateAdded = $dateAdded;
        return $this;
    }

    /**
     * @return string
     */
    public function getDateUpdated(): string
    {
        return $this->dateUpdated;
    }

    /**
     * @param string $dateUpdated
     * @return OrderTransformer
     */
    public function setDateUpdated(string $dateUpdated): OrderTransformer
    {
        $this->dateUpdated = $dateUpdated;
        return $this;
    }

    /**
     * @return array
     */
    public function getShipping(): array
    {
        return $this->shipping;
    }

    /**
     * @param array $shipping
     * @return OrderTransformer
     */
    public function setShipping(array $shipping): OrderTransformer
    {
        $this->shipping = $shipping;
        return $this;
    }

    /**
     * @return array
     */
    public function getCustomer(): array
    {
        return $this->customer;
    }

    /**
     * @param array $customer
     * @return OrderTransformer
     */
    public function setCustomer(array $customer): OrderTransformer
    {
        $this->customer = $customer;
        return $this;
    }

    /**
     * @return array
     */
    public function getReturnAddress(): array
    {
        return $this->returnAddress;
    }

    /**
     * @param array $returnAddress
     * @return OrderTransformer
     */
    public function setReturnAddress(array $returnAddress): OrderTransformer
    {
        $this->returnAddress = $returnAddress;
        return $this;
    }

    /**
     * @return array
     */
    public function getCheckoutData(): array
    {
        return $this->checkoutData;
    }

    /**
     * @param array $checkoutData
     * @return OrderTransformer
     */
    public function setCheckoutData(array $checkoutData): OrderTransformer
    {
        $this->checkoutData = $checkoutData;
        return $this;
    }

    /**
     * @return array
     */
    public function getOrderMetadata(): array
    {
        return $this->orderMetadata;
    }

    /**
     * @param array $orderMetadata
     * @return OrderTransformer
     */
    public function setOrderMetadata(array $orderMetadata): OrderTransformer
    {
        $this->orderMetadata = $orderMetadata;
        return $this;
    }

    /**
     * @return array
     */
    public function getOrderItems(): array
    {
        return $this->orderItems;
    }

    /**
     * @param array $orderItems
     * @return OrderTransformer
     */
    public function setOrderItems(array $orderItems): OrderTransformer
    {
        $this->orderItems = $orderItems;
        return $this;
    }

    public function toArray(): array
    {
        return array_filter([
            'source_id' => $this->sourceId,
            'email' => $this->email,
            'shipping_method' => $this->shippingMethod,
            'shipping_total' => $this->shippingTotal,
            'handling_total' => $this->handlingTotal,
            'tax_total' => $this->taxTotal,
            'date_added' => $this->dateAdded,
            'date_updated' => $this->dateUpdated,
            'shipping' => $this->shipping,
            'customer' => $this->customer,
            'return_address' => $this->returnAddress,
            'checkout_data' => $this->checkoutData,
            'order_metadata' => $this->orderMetadata,
            'order_items' => $this->orderItems
        ]);
    }
}