<?php

namespace Ptb\OrderDesk\Services;

use Ptb\OrderDesk\Contracts\ApiServiceContract;

final class GetOrdersService extends ApiServiceContract
{
    /**
     * @param array $parameters
     *
     * Parameter	Description
     * folder_id	Search for orders from a particular folder. For multiple folders, enter multiple ID's separated by a comma: 1004,1009,1010
     * folder_name	Search for orders from a particular folder. Enter the folder's exact name instead of its ID.
     * source_id	The source id
     * source_name	The source name
     * search_start_date_local	Start date from when an order was added. Search in local store time.
     * search_end_date_local	End date from when an order was added. Search in local store time.
     * search_start_date	Start date from when an order was added. Search in UTC time.
     * search_end_date	End date from when an order was added. Search in UTC time.
     * modified_start_date	Start date from when an order was modified. Search in UTC time.
     * modified_end_date	End date from when an order was modified. Search in UTC time.
     * email	Search for orders with a particular email address
     * customer_id	Search for orders with a particular customer ID
     * customer_first_name	Search the customer first name field
     * customer_last_name	Search the customer first name field
     * customer_company	Search the customer company field
     * customer_address1	Search the customer address1 field
     * shipping_first_name	Search the shipping first name field
     * shipping_last_name	Search the shipping first name field
     * shipping_company	Search the shipping company field
     * shipping_address1	Search the shipping address1 field
     * customer_phone	Search the customer phone field
     * shipping_phone	Search the shipping phone field
     * get_order_history	Set this to 1 to include order history. This slows down the results considerably so use carefully.
     * order_by	Order the query by an order field. Defaults to date_added
     * order	ASC or DESC, defaults to DESC
     * limit	How many orders to return, defaults to 50, limit of 500
     * offset	The number of records to offset
     *
     * @return array|mixed
     */
    public function handle(array $parameters = [])
    {
        $response = $this->http()->get('orders', $parameters);

        return $response->json();
    }
}