<?php

namespace Ptb\OrderDesk\Contracts;

use Illuminate\Support\Facades\Http;

abstract class ApiServiceContract
{
    protected array $_config;

    public function __construct()
    {
        $this->_config = config('orderdesk');
    }

    public function http()
    {
        return Http::asJson()
            ->acceptJson()
            ->baseUrl(data_get($this->_config, 'base_uri'))
            ->withHeaders([
                'ORDERDESK-STORE-ID' => data_get($this->_config, 'store_id'),
                'ORDERDESK-API-KEY' => data_get($this->_config, 'api_key')
            ]);
    }
}