<?php

namespace Ptb\OrderDesk\Tests\Feature;

use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Foundation\Testing\WithFaker;
use Illuminate\Support\Facades\Http;
use Ptb\OrderDesk\Tests\TestCase;
use Ptb\OrderDesk\Services\PingService;

class PingServiceTest extends TestCase
{
    /** @test */
    public function can_make_ping_request()
    {
        Http::fake([
            config('orderdesk.base_uri') . '/test' => [
                'status' => 'success',
                'message' => 'Connection successful',
                'current_date_time' => '1970-01-01 00:00:00'
            ]
        ]);

        $result = (new PingService)->handle();

        $this->assertIsArray($result);
        $this->assertArrayHasKey('status', $result);
        $this->assertArrayHasKey('message', $result);
        $this->assertArrayHasKey('current_date_time',$result);
        $this->assertEquals('success', data_get($result, 'status'));
        $this->assertEquals('Connection successful', data_get($result, 'message'));
    }
}
