<?php

namespace Ptb\OrderDesk\Services;

use Ptb\OrderDesk\Concerns\ValidatesPayload;
use Ptb\OrderDesk\Contracts\ApiServiceContract;

class CreateOrderService extends ApiServiceContract
{
    use ValidatesPayload;

    protected function getValidationRules(): array
    {
        return [
            'shipping.first_name' => 'required_without:shipping.company',
            'shipping.last_name' => 'required_without:shipping.company',
            'shipping.company' => 'required_without:shipping.first_name,shipping.last_name',
            'shipping.address1' => 'required',
            'shipping.city' => 'required',
            'shipping.state' => 'required|size:2',
            'shipping.postal_code' => 'required',
            'shipping.country' => 'required|size:2',
            'order_items' => 'required|array|size:1'
        ];
    }

    public function handle(array $order)
    {
        $this->validate($order);

        // append ship notify url to order metadata
        data_set($order, 'order_metadata.ship_notify_url', route('orderdesk.shipment-notification'));

        $response = $this->http()
            ->post('orders', $order);

        return $response->json();
    }
}