<?php

namespace Ptb\OrderDesk\Http\Controllers;

use Illuminate\Http\Request;
use Ptb\OrderDesk\Events\ShipmentNotificationEvent;

class ShipmentNotificationController extends Controller
{

    public function __invoke(Request $request)
    {
        $order = $request->json('order');
        $shipment = $request->json('shipment');
        $shipment_notification_event = new ShipmentNotificationEvent($order, $shipment);
        event($shipment_notification_event);

        return response()->json(null);
    }
}
