<?php

namespace Ptb\OrderDesk\Events;

use Illuminate\Foundation\Events\Dispatchable;

class ShipmentNotificationEvent
{
    use Dispatchable;

    protected array $order;
    protected array $shipment;

    public function __construct(array $order, array $shipment)
    {
        $this->order = $order;
        $this->shipment = $shipment;
    }

    public function getSourceId()
    {
        return data_get($this->order, 'source_id');
    }

    public function getTrackingNumber()
    {
        return data_get($this->shipment, 'tracking_number');
    }

    public function getDateShipped()
    {
        return data_get($this->shipment, 'date_shipped');
    }
}
