# Installation

## Existing Laravel Project

Add the following to your composer.json
```
{
  "repositories": [{
    "type": "composer",
    "url": "https://packagist.pointbsolutions.dev"
  }]
}
```

Install the package
```
composer require ptbsolutions\laravel-orderdesk
```

# Usage

## Update .env

```
ORDERDESK_STORE_ID=xxx
ORDERDESK_API_KEY=xxxx
```

## Create an order

```
use Ptb\OrderDesk\Services\CreateNewOrderService;
use Ptb\OrderDesk\Transformers\AddressTransformer;
use Ptb\OrderDesk\Transformers\OrderItemTransformer;
use Ptb\OrderDesk\Transformers\OrderTransformer;

$shipping = (new AddressTransformer)
    ->setFirstName('Fred')
    ->setLastName('Kruger')
    ->setCompanyName('optional, required if no first/last name')
    ->setAddress1('1234 Elm St')
    ->setAddress2('optional')
    ->setCity('Nowheresville')
    ->setState('MN')
    ->setPostalCode('55001')
    ->setCountry('US');

$items = collect();
$item = (new OrderItemTransformer)
    ->setCode('sku-1')
    ->setQuantity(1)
    ->setPrice(100.00)
    ->setVariationList([
        'variantKey' => 'variantValue'
    ])
    ->setMetadata([
        'metaKey' => 'metaValue'
    ]);
$items->push($item->toArray());

// add more items

// Source ID is your application internal order id
$order = (new OrderTransformer)
    ->setSourceId(1000)
    ->setEmail('freddy@nightmaresinc.com')
    ->setShipping($shipping->toArray())
    ->setOrderItems($items->toArray())
    ->setCheckoutData([
        'key' => 'value'
    ])
    ->setOrderMetadata([
        'metaKey' => 'metaValue'
    ]);

try {
    $result = (new CreateNewOrderService)->handle($order->toArray());
    if (data_get($result, 'status') === 'success') {
        $order_desk_order = data_get($result, 'order');
        $order_desk_id = data_get($order_desk_order, 'id');
    } else {
    }
} catch (ValidationException $ex) {
    // do something with $ex->errors();
}

```
## Handle shipment event

Add something like the following to your application's EventServiceProvider
```
use Ptb\OrderDesk\Events\ShipmentNotification

Event::listen(function (ShipmentNotificationEvent $event) {
    logger()->info('Source ID: ' . $event->getSourceId());
    logger()->info('Tracking Number: ' . $event->getTrackingNumber());
    logger()->info('Date Shipped: ' . $event->getDateShipped());
});
```
