<?php

namespace Ptb\OrderDesk\Tests\Feature;

use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Foundation\Testing\WithFaker;
use Illuminate\Support\Facades\Http;
use Illuminate\Validation\ValidationException;
use Ptb\OrderDesk\Services\CreateOrderService;
use Ptb\OrderDesk\Tests\TestCase;
use Ptb\OrderDesk\Transformers\AddressTransformer;
use Ptb\OrderDesk\Transformers\OrderItemTransformer;
use Ptb\OrderDesk\Transformers\OrderTransformer;

class CreateOrderServiceTest extends TestCase
{
    use WithFaker;

    /**
     * @test
     */
    public function cannot_make_create_order_request_with_invalid_data()
    {
        $this->expectException(ValidationException::class);

        Http::fake([
            config('orderdesk.base_uri') . '/orders' => [
                'status' => 'success',
                'message' => 'Connection successful',
                'order' => [
                    'id' => 1234
                ]
            ]
        ]);

        $orderItems = collect();

        $item = (new OrderItemTransformer())
            ->setCode('test-sku')
            ->setPrice(5.00)
            ->setQuantity(4)
            ->toArray();
        $orderItems->push($item);

        $order = (new OrderTransformer())
            ->setSourceId($this->faker->randomDigitNotNull)
            ->setEmail($this->faker->safeEmail)
            ->setShipping((new AddressTransformer())->toArray())
            ->setOrderItems($orderItems->toArray())
            ->toArray();

        (new CreateOrderService())->handle($order);
    }
}
